
#ifndef SST_TST_ATP_UTILITY_H
#define SST_TST_ATP_UTILITY_H

#if TST_USE_SST_UTIL_MODULE

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
  *  Object %name    : %
  *  State           :  %state%
  *  Creation date   :  Mon Mar 28 12:06:34 2005
  *  Last modified   :  %modify_time%
  */
  /** @file
  *  \brief A brief description of this module
  *
  *  \version SST_TST_ATP_Utility.h#1:incl:1
  *  \author Sagitb
  *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
  *           All Rights reserved
  */

  /************************ Defines *******************************/
  /************************ Enums *********************************/
  /************************ Typedefs  *****************************/
  /************************ Structs  ******************************/
  /*Authenticator test struct*/

  /************************ Public Variables **********************/
  /************************ Public Functions **********************/
  /*****************************************************************************/
  /****************************************************************
  * Function Name:
  *  SST_TST_ATP_UtilityOp
  *
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return
  *
  * Description:
  * Test the handle build and handle type retrieval
  *
  * Algorithm:
  * 1.  Create a new session by calling SST_SessionCreate.
  * 2.  Open a transaction by calling SST_TransactionStart.
  * 3.  Insert a new data object by calling SST_InsertData with a user defined handle.
  * 4.  Build a handle by calling SST_DataHandleBuild
  * 5.  Read a data object using this handle by calling SST_DataRead.
  * 6.  Validate this is the same data by comparing the retrieved data with the inserted data
  * 7.  Validate the handle type by calling SST_DataTypeGet.
  * 8.  Delete the data by calling SST_DeleteData.
  * 9.  Close the transaction by calling SST_TransactionClose.
  * 10. Delete the session by calling SST_SessionDelete.
  ********************************************************************************/
 DxError_t SST_TST_ATP_UtilityHandle ( void );
 
 /****************************************************************
* Function Name:
*  SST_TST_ATP_UtilityHandle
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the handle build and handle type retrieval
*
* Algorithm:
* 1.  Terminate the SST.
* 2.  Init the SST for operations.
* 3.  Create a session for operations.
* 4.  Open a transaction for operations.
* 5.  Call SST_UtilNVSSizesGet with the MainDB handle.
* 6   Call SST_UtilNVSSizesGet with the TST_SecondaryDB handle.
* 7.  Call SST_UtilNVSMaxSizeSet of the MainDB with 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES. 
* 8.  Call SST_UtilNVSMaxSizeSet of the SecondaryDB with 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES.
* 9.  Call SST_UtilNVSMaxSizeSet with a DB size smaller then the DB used size, should fail.
* 10. Call SST_UtilNVSMaxSizeSet with a DB size larger then the max DB  size, should fail.
* 11. Call SST_UtilNVSMaxSizeSet with an invalid handle, should fail.
* 12. Call SST_UtilNVSMaxSizeSet with size that is smaller from max size but bigger from currant size.
* 13. Call SST_UtilNVSSizesGet of the main DB and check that the max size equals to the one entered 
      in the previous operation.
* 14. Call SST_UtilNVSSizesGet of the Secondary DB and validate the max size did not change.
* 15. Call SST_DataInsert with data element that will exceed the current max database size, should fail.
* 16. Close the transaction.
* 17. Open a transaction for operations.
* 18. Call SST_UtilNVSSizesGet of the  MainDB used size should remain the same.
* 19. Call SST_UtilNVSSizesGetof the  SecondaryDB, used size should remain the same.
* 20. Increase the max size of the DB .
* 21. Call SST_DataInsert with data element again.
* 22. Modify the data.
* 23. Call Transaction Rollback.
* 24. Open a transaction for operations.
* 25. Insert a new Data object.
* 26. Delete the data.
* 26.a SST_UtilNVSMaxSizeSet MainDB to 20500
* 27. insert 6 data objects the 6 should fail.
* 28. Delete the data objects.
* 29. Insert 5 data objects.
* 30. Delete the data objects.
* 31. Set the max Size of both DB to 0x7fffffff.
* 32. Close the transaction.
* 33. Delete the session.
********************************************************************************/
 
 DxError_t SST_TST_ATP_UtilitySize ( void );
 
 /****************************************************************
* Function Name:
*  SST_TST_ATP_UtilitySizeWithKeys
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the size control utility functions with keys
*
* Algorithm:
* 1.  Terminate the SST.
* 2.  Init the SST for operations.
* 3.  Create a session for operations.
* 4.  Open a transaction for operations.

* 31. Get current size and set MainFile to AES key size + overhead + current
*     Insert AES key -> generate AES key (fail) -> delete AES key from DB ->
*     Generate AES Key (This test to check deleted list)
* 31.a Get current - Main
* 31.b Set max size - Main
* 31.c Insert first AES Key
* 31.d Generate AES key (fail)
* 31.e delete AES key
* 31.f generate AES key
* 32. Get current size and set MainFile to AES key size + overhead + current
*     Insert AES key -> Insert AES key (fail) -> delete AES key from DB ->
*     Insert AES key (This test to check deleted list)
* 32.a Get current - Main
* 32.b Set max size - Main
* 32.c Insert first AES Key 
* 32.d Insert second AES Key (fail)
* 32.e delete AES key
* 32.f Insert AES key
* 33. Set the max Size of both DB to 0x7ffffff0
* 34. Close the transaction.
* 35. Delete the session.
********************************************************************************/
DxError_t SST_TST_ATP_UtilitySizeWithKeys ( void );


#ifdef __cplusplus
}
#endif

#endif

#endif



